<?php

namespace App\View\Components\Admin;

use Closure;
use Illuminate\View\Component;
use App\Models\Sections\Section;
use App\Models\Sections\SectElType;
use Illuminate\Contracts\View\View;
use App\Models\Sections\SectionElement;

class NestableSectionElementsList extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(public Section $section)
    {
        //
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.admin.nestable-section-elements-list', [
            'sectionElementTypes' => SectElType::all(),
            'sectionElements' => $this->section->sectionElements()->with(['sectElFields', 'sectElType'])->defaultOrder()->get()->toTree()
        ]);
    }
}
