<?php

namespace App\Traits;

trait Filterable
{
    // public function scopeFilterTranslations($query, string $search): void
    // {
    //     $search = preg_replace('/[^A-Za-z0-9\-]/', ' ', $search);
    //     if ($search !== ' ') {
    //         $query->whereHas(
    //             'translations',
    //             fn($query) => $query
    //                 ->whereFullText('title', '*' . $search . '*', ['mode' => 'boolean'])
    //                 ->orWhereFullText('description', '*' . $search . '*', ['mode' => 'boolean'])
    //                 ->orWhereFullText('meta_title', '*' . $search . '*', ['mode' => 'boolean'])
    //                 ->orWhereFullText('meta_description', '*' . $search . '*', ['mode' => 'boolean'])
    //         );
    //     }
    // }

    public function scopeFilterTranslations($query, string $search)
    {
        $search = preg_replace('/[^\p{L}\p{N}\s\-]/u', ' ', $search);
        $search = trim($search);

        if ($search !== '') {
            $words = explode(' ', $search);
            $words = array_filter($words, fn($word) => mb_strlen($word) > 2);

            if (!empty($words)) {
                $terms = collect($words)
                    ->map(fn($word) => '+' . $word . '*')
                    ->implode(' ');

                $query->whereHas(
                    'translations',
                    fn($query) => $query
                        ->whereFullText('title', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('description', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('meta_title', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('meta_description', $terms, ['mode' => 'boolean'])
                );
            }
        }
    }

    public function scopeFilterTranslationsWithTextContent($query, string $search)
    {
        $search = preg_replace('/[^\p{L}\p{N}\s\-]/u', ' ', $search);
        $search = trim($search);

        if ($search !== '') {
            $words = explode(' ', $search);
            $words = array_filter($words, fn($word) => mb_strlen($word) > 2);

            if (!empty($words)) {
                $terms = collect($words)
                    ->map(fn($word) => '+' . $word . '*')
                    ->implode(' ');

                $query->whereHas(
                    'translations',
                    fn($query) => $query
                        ->whereFullText('title', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('description', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('meta_title', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('meta_description', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('text_content', $terms, ['mode' => 'boolean'])
                );
            }
        }
    }

    public function scopeFilterUsers($query, string $search)
    {
        $search = preg_replace('/[^\p{L}\p{N}\s\-]/u', ' ', $search);
        $search = trim($search);

        if ($search !== '') {
            $words = explode(' ', $search);
            $words = array_filter($words, fn($word) => mb_strlen($word) > 2);

            if (!empty($words)) {
                $terms = collect($words)
                    ->map(fn($word) => '+' . $word . '*')
                    ->implode(' ');

                $query->whereFullText('name', $terms, ['mode' => 'boolean'])
                    ->orWhereFullText('email', $terms, ['mode' => 'boolean']);
            }
        }
    }

    public function scopeFilterMenus($query, string $search)
    {
        $search = preg_replace('/[^\p{L}\p{N}\s\-]/u', ' ', $search);
        $search = trim($search);

        if ($search !== '') {
            $words = explode(' ', $search);
            $words = array_filter($words, fn($word) => mb_strlen($word) > 2);

            if (!empty($words)) {
                $terms = collect($words)
                    ->map(fn($word) => '+' . $word . '*')
                    ->implode(' ');

                $query
                    ->whereHas('translations', fn($query) => $query->whereFullText('title', $terms, ['mode' => 'boolean']));
            }
        }
    }

    public function scopeFilterMenuItems($query, string $search)
    {
        $search = preg_replace('/[^\p{L}\p{N}\s\-]/u', ' ', $search);
        $search = trim($search);

        if ($search !== '') {
            $words = explode(' ', $search);
            $words = array_filter($words, fn($word) => mb_strlen($word) > 2);

            if (!empty($words)) {
                $terms = collect($words)
                    ->map(fn($word) => '+' . $word . '*')
                    ->implode(' ');

                $query->whereHas(
                    'translations',
                    fn($query) => $query
                        ->whereFullText('title', $terms, ['mode' => 'boolean'])
                        ->orWhereFullText('link', $terms, ['mode' => 'boolean'])
                );
            }
        }
    }

    public function scopePageWithFullContent($query)
    {
        return $query->with([
            'translations',
            'sections' => fn($q) => $q->where('is_active', true)->defaultOrder(),
            'sections.sectionType',
            'sections.sectionType.sectionTypeFields',
            'sections.sectionFields',
            'sections.sectionElements' => fn($q) => $q->where('is_active', true),
            'sections.sectionElements.sectElFields',
            'sections.sectionElements.sectElType',
            'sections.sectionElements.sectElType.fields',
        ]);
    }
}
