<?php

namespace App\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Http\FormRequest;

class ToggleSwitch
{
    public function __invoke(FormRequest $request, Model $model, string $field = 'is_active'): bool
    {
        if ((int) $request->$field === 0) {
            $request[$field] = 1;
        } else {
            $request[$field] = 0;
        }

        if (!$model->update([$field => $request->$field])) {
            return false;
        }

        return true;
    }
}
