<?php

namespace App\Services;

use Illuminate\Support\Collection;
use Illuminate\Pagination\LengthAwarePaginator as Paginator;

class Paginate
{
    public function __invoke(Collection $usersCollection, int $perPage = 10): Paginator
    {
        $currentPage = request("page") ?? 1;
        $startingPoint = ($currentPage * $perPage) - $perPage;

        return new Paginator(
            $usersCollection->slice($startingPoint, $perPage),
            $usersCollection->count(),
            $perPage,
            $currentPage,
            [
                'path' => request()->url(),
                'query' => request()->query(),
            ]
        );
    }
}
