<?php

namespace App\Services;

use App\Models\Menu;

class MenuService
{
    public function __invoke(): array
    {
        $menuTypesConfig = collect(config('menus.types'));
        $menuTypes = [
            'main' => $menuTypesConfig->where('type', 'main')->first(),
            'fast_links' => $menuTypesConfig->where('type', 'fast_links')->first(),
        ];

        $menus = Menu::where('is_active', true)->with('menuItems', 'menuItems.children')->defaultOrder()->get()->toTree();
        if ($menus->count() > 0) {
            $mainMenu = $menus->where('type', $menuTypes['main']['id'])->first();
            $fastLinksMenu = $menus->where('type', $menuTypes['fast_links']['id'])->first();
        }

        return [
            'menuTypes' => $menuTypes,
            'mainMenu' => $mainMenu ?? null,
            'fastLinksMenu' => $fastLinksMenu ?? null,
        ];
    }
}
