<?php

namespace App\Providers;

use Illuminate\Pagination\Paginator;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Model::preventLazyLoading(!app()->isProduction());

        Paginator::useBootstrapFive();

        $languages = languages();
        if ($languages->isNotEmpty()) {
            $locales = $languages->pluck('locale')->toArray();
        } else {
            $locales = [];
        }

        config(['translatable.locales' => $locales]);
    }
}
