<?php

namespace App\Models\Sections;

use App\Forms\InputFieldNames;
use App\Models\Sections\SectElType;
use Illuminate\Database\Eloquent\Model;
use App\Models\Sections\SectionTypeField;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SectionType extends Model
{
    use HasFactory;

    public function sectionTypeFields(): HasMany
    {
        return $this->hasMany(SectionTypeField::class);
    }

    public function sectElType(): HasOne
    {
        return $this->hasOne(SectElType::class);
    }

    public function hasTitle(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::TITLE);
    }

    public function hasSubtitle(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::SUBTITLE);
    }

    public function hasTextContent(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::TEXT_CONTENT);
    }

    public function hasDescription(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::DESCRIPTION);
    }

    public function hasColor()
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::COLOR);
    }

    public function hasImage(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::IMAGE);
    }

    public function hasTitleImage(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::TITLE_IMAGE);
    }

    public function hasBackgroundImage(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BACKGROUND_IMAGE);
    }

    public function hasButtonText(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_TEXT);
    }

    public function hasButtonLink(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_LINK);
    }

    public function hasButtonRightText(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_RIGHT_TEXT);
    }

    public function hasButtonRightLink(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_RIGHT_LINK);
    }

    public function hasButtonLeftText(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_LEFT_TEXT);
    }

    public function hasButtonLeftLink(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_LEFT_LINK);
    }

    public function hasButtonCenterText(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_CENTER_TEXT);
    }

    public function hasButtonCenterLink(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::BUTTON_CENTER_LINK);
    }

    public function hasSearchTitle(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::SEARCH_TITLE);
    }

    public function hasHeaderBlockTitle(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::HEADER_BLOCK_TITLE);
    }

    public function hasHeaderBlockSubtitle(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::HEADER_BLOCK_SUBTITLE);
    }

    public function hasLeftColumnTextContent(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::LEFT_COLUMN_TEXT_CONTENT);
    }

    public function hasRightColumnTextContent(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::RIGHT_COLUMN_TEXT_CONTENT);
    }

    public function hasOrganization(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::ORGANIZATION);
    }

    public function hasIndustry(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::INDUSTRY);
    }

    public function hasSolution(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::SOLUTION);
    }

    public function hasProducts(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::PRODUCTS);
    }

    public function hasLocation(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::LOCATION);
    }

    public function hasWebsite(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::WEBSITE);
    }

    public function hasAuthor(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::AUTHOR);
    }

    public function hasPosition(): bool
    {
        return $this->sectionTypeFields->contains('name', InputFieldNames::POSITION);
    }
}
