<?php

namespace App\Models\Sections;

use App\Forms\InputFieldNames;
use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SectionField extends Model
{
    use HasFactory, Translatable;

    protected $guarded = ['id'];

    protected $with = ['translations'];

    public array $translatedAttributes = [
        'int_value',
        'string_value',
        'text_value',
        'boolean_value',
    ];

    public function getTitleAttribute()
    {
        $titleType = $this->section->sectionType->sectionTypeFields->where('name', InputFieldNames::TITLE)->first();
        return $this->section->sectionFields()->where('section_type_field_id', $titleType->id)->first();
    }
}
