<?php

namespace App\Models\Sections;

use App\Forms\DataTypes;
use App\Forms\InputFieldNames;
use App\Models\Sections\SectElType;
use Illuminate\Database\Eloquent\Model;

class SectElTypeField extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function sectElType()
    {
        return $this->belongsTo(SectElType::class);
    }

    public function isString(): bool
    {
        return $this->data_type === DataTypes::STRING && !$this->isImage();
    }

    public function isInteger(): bool
    {
        return $this->data_type === DataTypes::INTEGER;
    }

    public function isText(): bool
    {
        return $this->data_type === DataTypes::TEXT && !$this->isImage();
    }

    public function isImage(): bool
    {
        return $this->name === InputFieldNames::IMAGE
            || $this->name === InputFieldNames::BIG_IMAGE
            || $this->name === InputFieldNames::SMALL_IMAGE
            || $this->name === InputFieldNames::BACKGROUND_IMAGE;
    }
}
