<?php

namespace App\Models\Sections;

use App\Models\Sections\SectionType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SectElType extends Model
{
    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function fields(): HasMany
    {
        return $this->hasMany(SectElTypeField::class);
    }

    public function sectionType(): BelongsTo
    {
        return $this->belongsTo(SectionType::class);
    }
}
