<?php

namespace App\Models;

use App\Models\PageType;

use App\Traits\Sluggable;
use App\Traits\Filterable;
use App\Traits\Statusable;

use Kalnoy\Nestedset\NodeTrait;
use App\Models\Sections\Section;
use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Page extends Model
{
    use HasFactory, Translatable, NodeTrait, Sluggable, Statusable, Filterable;

    protected static function boot()
    {
        parent::boot();

        static::deleting(function ($page) {
            $page->sections->each->delete();
        });
    }

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $with = ['translations'];

    public function sections(): MorphMany
    {
        return $this->morphMany(Section::class, 'sectionable');
    }

    public function pageType(): BelongsTo
    {
        return $this->belongsTo(PageType::class);
    }

    public array $translatedAttributes = [
        "title",
        "slug",
        "description",
        "meta_title",
        "meta_description"
    ];
}
