<?php

namespace App\Models;

use App\Traits\Filterable;
use Kalnoy\Nestedset\NodeTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Astrotomic\Translatable\Translatable;

class MenuItem extends Model
{
    use NodeTrait, Filterable, Translatable;

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $with = ['translations'];

    public array $translatedAttributes = [
        "title",
        "link"
    ];

    public function menu(): BelongsTo
    {
        return $this->belongsTo(Menu::class);
    }

    public function children(): HasMany
    {
        return $this->hasMany(MenuItem::class, 'parent_id')->defaultOrder();
    }
}
