<?php

namespace App\Models;

use App\Traits\Filterable;
use App\Traits\Statusable;
use Kalnoy\Nestedset\NodeTrait;
use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Menu extends Model
{
    use Filterable, Statusable, NodeTrait, Translatable;

    protected $guarded = ['id', 'created_at', 'updated_at'];

    protected $with = ['translations'];

    public array $translatedAttributes = [
        "title"
    ];

    public function menuItems(): HasMany
    {
        return $this->hasMany(MenuItem::class)->defaultOrder();
    }
}
