<?php

namespace App\Models;

use App\Models\Sections\Section;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphToMany;
use Astrotomic\Translatable\Translatable;


class Image extends Model
{
    use Translatable;

    protected $with = ['translations'];

    public array $translatedAttributes = [
        "title",
        "description",
        "alt"
    ];

    protected $guarded = ['id', 'created_at', 'updated_at'];

    public function imageable(): MorphToMany
    {
        return $this->morphedByMany(Section::class, 'imageable'); // Classes can be Section, Page, Post, etc. In array.
    }
}
