<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Astrotomic\Translatable\Validation\RuleFactory;

class UserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        $rules = [
            'name'  => ['required', 'string', 'min:5', 'max:255'],
        ];

        $user = $this->client ?? $this->business ?? $this->admin;

        if (!empty($user->id)) {
            $rules['email']                 = ['required', 'string', 'email', 'min:5', 'max:255', 'unique:users,email,' . $user->id];
            $rules['password']              = ['sometimes', 'nullable', 'confirmed', 'min:8', 'max:255'];
            $rules['password_confirmation'] = ['sometimes', 'nullable'];
        } else {
            $rules['email']                 = ['required', 'string', 'email', 'min:5', 'max:255', 'unique:users,email'];
            $rules['password']              = ['required', 'string', 'confirmed', 'min:8', 'max:255'];
            $rules['password_confirmation'] = ['required'];
        }

        return RuleFactory::make($rules);
    }
}
