<?php

namespace App\Http\Requests\Admin;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Log;
use Illuminate\Foundation\Http\FormRequest;
use Astrotomic\Translatable\Validation\RuleFactory;

class SectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        if ($this->method() === 'PATCH') {
            $rules = [
                'is_active' => ['in:0,1']
            ];
        } else {
            $rules = [
                'is_active' => ['in:0,1'],
                'cover_image' => ['nullable', 'sometimes', 'string', 'max:255'],
                'sectionable_id' => ['required', 'integer'],
                'sectionable_type' => ['required', 'string'],

                'fields.%title%' => ['required', 'nullable', 'string', 'min:3', 'max:255'],
                'fields.%subtitle%' => ['nullable', 'string', 'min:3', 'max:255'],
                'fields.%description%' => ['nullable', 'string'],
                'fields.%second_description%' => ['nullable', 'string'],
            ];
        }

        return RuleFactory::make($rules);
    }
}
