<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class SectionElementRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return[
            'admin_title' => ['required', 'string', 'min:3', 'max:255'],
            'is_active' => ['in:0,1'],
            'cover_image' => ['nullable', 'sometimes','string', 'max:255'],
            'sect_el_type_id' => ['required', 'integer'],
            'section_id' => ['required', 'integer'],
        ];
    }
}
