<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Astrotomic\Translatable\Validation\RuleFactory;

class MenuRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if ($this->method() === 'PATCH') {
            $rules = [
                'is_active' => ['in:0,1']
            ];
        } else {
            $rules = [
                '%title%' => ['required', 'string', 'max:255'],
                'type' => ['nullable', 'sometimes', 'integer'],
                'is_active' => ['in:0,1'],
            ];
        }

        return RuleFactory::make($rules);
    }
}
