<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Astrotomic\Translatable\Validation\RuleFactory;

class DomainRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'domain' => 'required|string|max:255',
            'logo' => 'nullable|string|max:255',
            'footer_logo' => 'nullable|string|max:255',
            'domain_image' => 'nullable|string|max:255',
            'twitter' => 'nullable|string|max:255',
            'facebook' => 'nullable|string|max:255',
            'instagram' => 'nullable|string|max:255',
            'linkedin' => 'nullable|string|max:255',
            'youtube' => 'nullable|string|max:255',
            'header_scripts' => 'nullable|string',
            'body_scripts' => 'nullable|string',

            '%privacy_policy_link%' => 'nullable|string|max:255',
        ];

        return RuleFactory::make($rules);
    }
}
