<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\View\View;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;

class UserController extends Controller
{
    function editOwnProfile(User $user): View
    {
        return view('admin.user.edit-profile', ['user' => $user]);
    }

    function editOwnPassword(User $user): View
    {
        return view('admin.user.edit-password', ['user' => $user]);
    }

    public function destroyOwnAcount(User $user): RedirectResponse
    {
        if (!request()->account_activation) {
            return back()->withError('Deactivation is not confirmed');
        }

        if (!$user->delete()) {
            return back()->withError('The user was not deleted. Please try again');
        }

        return to_route('home')->withSuccess('The page was deleted');
    }
}
