<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use Intervention\Image\ImageManager;
use Illuminate\Http\RedirectResponse;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Drivers\Gd\Driver;
use Symfony\Component\HttpFoundation\Response;

class PanelController extends Controller
{
    protected Model $model;

    private function destroyAjax(Model $record): JsonResponse
    {
        if (!$record->delete()) {
            return response()->json(['error' => 'The record was not deleted. Please try again.'], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
        return response()->json(['success' => 'The record was deleted'], Response::HTTP_OK);
    }

    private function destroyHttp(Model $record): RedirectResponse
    {
        if (!$record->delete()) {
            return back()->withError('The record was not deleted. Please try again.');
        }
        return back()->withSuccess('The record was deleted');
    }

    protected function createImagePreview(string $imagePath): void
    {
        $existingDirectory = dirname($imagePath);
        $newDirectory = $existingDirectory . '/preview/';
        if (!Storage::disk('public')->exists($newDirectory)) {
            Storage::disk('public')->makeDirectory($newDirectory, 0755, true);
        }

        $manager = new ImageManager(Driver::class);
        $image = $manager->read(storage_path('app/public/' . $imagePath));
        $image->scaleDown(width: 300);
        $scaledImagePath = $newDirectory . basename($imagePath);
        if (!Storage::disk('public')->exists($scaledImagePath)) {
            $image->save(storage_path('app/public/' . $scaledImagePath));
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(int $id): RedirectResponse|JsonResponse
    {
        $record = $this->model->findOrFail($id);

        if (request()->ajax()) {
            return $this->destroyAjax($record);
        }

        return $this->destroyHttp($record);
    }

    public function deleteCoverImage(int $id): JsonResponse
    {
        if (!$this->model->findOrFail($id)->update(['cover_image' => null])) {
            return response()->json(['error' => 'Something went wrong'], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
        return response()->json(['success' => 'The cover image was deleted'], Response::HTTP_OK);
    }

    public function deleteSecondaryImage(int $id): JsonResponse
    {
        if (!$this->model->findOrFail($id)->update(['secondary_image' => null])) {
            return response()->json(['error' => 'Something went wrong'], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
        return response()->json(['success' => 'The secondary image was deleted'], Response::HTTP_OK);
    }
}
