<?php

namespace App\Http\Controllers\Admin;

use App\Models\Menu;
use App\Models\MenuItem;
use App\Traits\Sortable;
use Illuminate\View\View;
use App\Services\ToggleSwitch;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use App\Http\Requests\Admin\MenuItemRequest;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Controllers\Admin\PanelController;

class MenuItemController extends PanelController
{
    use Sortable;

    const SEARCH_ROUTE = 'admin.settings.menus.index';

    public function __construct()
    {
        $this->model = new MenuItem();
    }

    public function create()
    {
        return view('admin.settings.menus.menu-items.create', [
            'searchRoute' => self::SEARCH_ROUTE,
            'menu' => Menu::findOrFail(request()->menu),
            'languages' => languages(),
        ]);
    }

    public function store(MenuItemRequest $request): RedirectResponse
    {
        $menu = Menu::findOrFail($request->menu_id);
        if (!$menuItem = $menu->menuItems()->create($request->except(['_token', '_method', 'save', 'save_close']))) {
            return back()->withErrors('Something went wrong.');
        }

        if ($request->save_close) {
            return to_route('admin.settings.menus.menu-items.index')->withSuccess('The menu item was created.');
        }

        return to_route('admin.settings.menus.menu-items.edit', $menuItem)->withSuccess('The menu item was created.');
    }

    public function edit(MenuItem $menuItem): View
    {
        return view('admin.settings.menus.menu-items.edit', [
            'menuItem' => $menuItem,
            'languages' => languages(),
        ]);
    }

    public function update(MenuItemRequest $request, MenuItem $menuItem): RedirectResponse
    {
        if (!$menuItem->update($request->except(['_token', '_method', 'save', 'save_close']))) {
            return back()->withErrors('Something went wrong.');
        }

        if ($request->save_close) {
            return to_route('admin.settings.menus.menu-items.index')->withSuccess('The menu item was updated.');
        }

        return back()->withSuccess('The menu item was updated.');
    }
}
