<?php

namespace App\Http\Controllers\Admin;

use App\Models\Image;
use Illuminate\View\View;
use Illuminate\Http\Request;
use App\Models\Sections\Section;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Controllers\Admin\PanelController;

class ImageController extends PanelController
{
    public function __construct()
    {
        $this->model = new Image();
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Image $image, string $parentPath, int $parentId): View
    {
        $image->load('imageable');
        $languages = languages();
        return view('admin.images.edit', compact('image', 'parentPath', 'parentId', 'languages'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Image $image): RedirectResponse
    {
        $image->update($request->all());
        return redirect()->back()->with('success', 'Image updated successfully');
    }

    public function getOrder(Request $request): JsonResponse
    {
        $section = Section::find($request->get('parent_id'));
        return response()->json(['order' => $section->imagesOrdered()->pluck('id')->toArray()], Response::HTTP_OK);
    }

    public function changeOrder(Request $request): JsonResponse
    {
        foreach ($request->get('order') as $id => $order) {
            Image::find($id)->update(['order' => $order]);
        }

        return response()->json(['success' => 'Images order updated successfully'], Response::HTTP_OK);
    }
}
