<?php

namespace App\Http\Controllers\Admin;

use App\Models\Domain;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use Symfony\Component\HttpFoundation\Response;
use App\Http\Requests\Admin\DomainRequest;
use Illuminate\Http\RedirectResponse;

class DomainController extends Controller
{
    public function index()
    {
        return view('admin.settings.domains.index', ['domains' => Domain::with('translations')->paginate(10)]);
    }

    public function create()
    {
        return view('admin.settings.domains.create', ['languages' => languages()]);
    }

    public function store(DomainRequest $request): RedirectResponse
    {
        $domain = Domain::create($request->except(['_token', '_method', 'save', 'save_close']));

        if ($request->save) {
            return to_route('admin.settings.domains.edit', $domain)->withSuccess('The domain was created.');
        }

        if ($request->save_close) {
            return to_route('admin.settings.domains.index')->withSuccess('The domain was created.');
        }

        return redirect()->route('admin.settings.domains.index')->with('success', 'Domain created successfully');
    }

    public function edit(Domain $domain)
    {
        return view('admin.settings.domains.edit', ['domain' => $domain, 'languages' => languages()]);
    }

    public function update(DomainRequest $request, Domain $domain)
    {
        if (!$domain->update($request->except(['_token', '_method', 'save', 'save_close']))) {
            return back()->withError('The changes were not saved. Please try again.');
        }

        if ($request->save) {
            return back()->withSuccess('The changes were saved.');
        }

        if ($request->save_close) {
            return to_route('admin.settings.domains.index')->withSuccess('The changes were saved.');
        }
    }

    public function destroy(Domain $domain): RedirectResponse
    {
        if (!$domain->delete()) {
            return back()->withError('The domain was not deleted.');
        }

        return to_route('admin.settings.domains.index')->withSuccess('The domain was deleted.');
    }

    public function deleteLogo(Domain $domain): JsonResponse
    {
        if (!$domain->update([request()->logoType => null])) {
            return response()->json(['error' => 'Something went wrong'], Response::HTTP_INTERNAL_SERVER_ERROR);
        }
        return response()->json(['success' => 'The logo was deleted'], Response::HTTP_OK);
    }
}
