<?php

namespace App\Http\Controllers\Admin;

use App\Models\Role;
use App\Models\User;
use Illuminate\Http\RedirectResponse;
use App\Http\Requests\Admin\UserRequest;
use App\Http\Controllers\Admin\PanelController;

class AdminController extends PanelController
{
    const ROUTE = 'admins';
    const SEARCH_ROUTE = 'admin.admins.index';
    const HEADING = 'administrators';

    public function __construct()
    {
        $this->model = new User();
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('admin.users.index', [
            'users' => User::select('id', 'name', 'email_verified_at')
                ->whereHas('role', fn ($query) => $query->where('name', 'admin'))
                ->when(request('search'), fn ($query, $search) => $query->filterUsers($search))
                ->paginate()
                ->withQueryString(),
            'heading' => self::HEADING,
            'route' => self::ROUTE,
            'searchRoute' => self::SEARCH_ROUTE,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.users.create', [
            'languages' => languages(),
            'heading' => self::HEADING,
            'route' => self::ROUTE,
            'searchRoute' => self::SEARCH_ROUTE,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(UserRequest $request): RedirectResponse
    {
        $request['role_id'] = Role::where('name', 'admin')->firstOrFail()->id;

        $admin = User::create($request->except(['_token', '_method', 'save', 'save_close']));

        if ($request->save) {
            return to_route('admin.admins.edit', $admin)->withSuccess('The admin was created.');
        }

        if ($request->save_close) {
            return to_route('admin.admins.index')->withSuccess('The admin was created.');
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(User $admin)
    {
        return view('admin.users.edit', [
            'user' => $admin,
            'heading' => self::HEADING,
            'route' => self::ROUTE
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UserRequest $request, User $admin)
    {
        $except = ['_token', '_method', 'save', 'save_close'];
        if (!$request->password) {
            array_push($except, 'password');
        }

        if (!$admin->update($request->except($except))) {
            return back()->withError('The changes were not saved. Please try again.');
        }

        if ($request->save) {
            return back()->withSuccess('The changes were saved.');
        }

        if ($request->save_close) {
            return to_route('admin.admins.index')->withSuccess('The changes were saved.');
        }
    }
}
