<?php

namespace App\Forms;

use App\Forms\SelectItem;
use Illuminate\Support\Collection;

class SelectList
{
    /**
     * @var array
     */
    protected $allowed = ['sections.colors', 'menus.types'];

    /**
     * @param string $listName
     * @return \Illuminate\Support\Collection
     */
    public function get(string $listName): Collection
    {
        $result = collect();

        if (!in_array($listName, $this->allowed)) {
            return $result;
        }

        $list = config($listName);
        foreach ($list as $item) {
            $result->push(new SelectItem($item['id'], $item['name']));
        }
        return $result;
    }
}
