<?php

namespace App\Forms;

use App\Forms\SelectItem;
use App\Forms\SelectList;
use Illuminate\Support\Collection;

class SelectColorList extends SelectList
{
    protected $allowed = [];

    public function get(string $listName): Collection
    {
        $result = collect();

        if (!in_array($listName, $this->allowed)) {
            return $result;
        }

        $list = config($listName);
        foreach ($list as $item) {
            $result->push(new SelectItem($item['id'], $item['name'], $item['hex']));
        }
        return $result;
    }
}
