<?php

// @formatter:off
// phpcs:ignoreFile
/**
 * A helper file for your Eloquent Models
 * Copy the phpDocs from this file to the correct Model,
 * And remove them from this file, to prevent double declarations.
 *
 * @author Barry vd. Heuvel <barryvdh@gmail.com>
 */


namespace App\Models{
/**
 * App\Models\Domain
 *
 * @property int $id
 * @property string $domain
 * @property string|null $logo
 * @property string|null $logo_mobile
 * @property string|null $footer_logo
 * @property string|null $footer_logo_mobile
 * @property string|null $phone
 * @property string|null $email
 * @property string|null $twitter
 * @property string|null $instagram
 * @property string|null $youtube
 * @property string|null $linkedin
 * @property string|null $facebook
 * @property string|null $domain_image
 * @property string|null $header_scripts
 * @property string|null $body_scripts
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\DomainTranslation|null $translation
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\DomainTranslation> $translations
 * @property-read int|null $translations_count
 * @method static \Illuminate\Database\Eloquent\Builder|Domain listsTranslations(string $translationField)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Domain newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Domain notTranslatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain orWhereTranslation(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain orWhereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain orderByTranslation(string $translationField, string $sortMethod = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|Domain query()
 * @method static \Illuminate\Database\Eloquent\Builder|Domain translated()
 * @method static \Illuminate\Database\Eloquent\Builder|Domain translatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereBodyScripts($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereDomain($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereDomainImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereFacebook($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereFooterLogo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereFooterLogoMobile($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereHeaderScripts($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereInstagram($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereLinkedin($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereLogo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereLogoMobile($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereTranslation(string $translationField, $value, ?string $locale = null, string $method = 'whereHas', string $operator = '=')
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereTwitter($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain whereYoutube($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Domain withTranslation(?string $locale = null)
 */
	class Domain extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\DomainTranslation
 *
 * @property int $id
 * @property int $domain_id
 * @property string|null $locale
 * @property string|null $privacy_policy_link
 * @method static \Illuminate\Database\Eloquent\Builder|DomainTranslation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|DomainTranslation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|DomainTranslation query()
 * @method static \Illuminate\Database\Eloquent\Builder|DomainTranslation whereDomainId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DomainTranslation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DomainTranslation whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|DomainTranslation wherePrivacyPolicyLink($value)
 */
	class DomainTranslation extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Image
 *
 * @property int $id
 * @property string $path
 * @property int $order
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Kalnoy\Nestedset\Collection<int, \App\Models\Sections\Section> $imageable
 * @property-read int|null $imageable_count
 * @property-read \App\Models\ImageTranslation|null $translation
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\ImageTranslation> $translations
 * @property-read int|null $translations_count
 * @method static \Illuminate\Database\Eloquent\Builder|Image listsTranslations(string $translationField)
 * @method static \Illuminate\Database\Eloquent\Builder|Image newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Image newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Image notTranslatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Image orWhereTranslation(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Image orWhereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Image orderByTranslation(string $translationField, string $sortMethod = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|Image query()
 * @method static \Illuminate\Database\Eloquent\Builder|Image translated()
 * @method static \Illuminate\Database\Eloquent\Builder|Image translatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Image whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Image whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Image whereOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Image wherePath($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Image whereTranslation(string $translationField, $value, ?string $locale = null, string $method = 'whereHas', string $operator = '=')
 * @method static \Illuminate\Database\Eloquent\Builder|Image whereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|Image whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Image withTranslation(?string $locale = null)
 */
	class Image extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\ImageTranslation
 *
 * @property int $id
 * @property int $image_id
 * @property string|null $locale
 * @property string|null $title
 * @property string|null $description
 * @property string|null $alt
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation query()
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation whereAlt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation whereImageId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ImageTranslation whereTitle($value)
 */
	class ImageTranslation extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Language
 *
 * @property int $id
 * @property string $name
 * @property string $code
 * @property string $locale
 * @property int $is_active
 * @property int $order
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|Language active()
 * @method static \Database\Factories\LanguageFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder|Language newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Language newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Language query()
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereIsActive($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereOrder($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Language whereUpdatedAt($value)
 */
	class Language extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Menu
 *
 * @property int $id
 * @property int|null $type
 * @property int $is_active
 * @property int $_lft
 * @property int $_rgt
 * @property int|null $parent_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Kalnoy\Nestedset\Collection<int, Menu> $children
 * @property-read int|null $children_count
 * @property-read \Kalnoy\Nestedset\Collection<int, \App\Models\MenuItem> $menuItems
 * @property-read int|null $menu_items_count
 * @property-read Menu|null $parent
 * @property-read \App\Models\MenuTranslation|null $translation
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\MenuTranslation> $translations
 * @property-read int|null $translations_count
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu active()
 * @method static \Kalnoy\Nestedset\Collection<int, static> all($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu ancestorsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu ancestorsOf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu applyNestedSetScope(?string $table = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu countErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu d()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu defaultOrder(string $dir = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu descendantsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu descendantsOf($id, array $columns = [], $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu filterMenuItems(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu filterMenus(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu filterTranslations(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu filterTranslationsWithTextContent(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu filterUsers(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu fixSubtree($root)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu fixTree($root = null)
 * @method static \Kalnoy\Nestedset\Collection<int, static> get($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu getNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu getPlainNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu getTotalErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu hasChildren()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu hasParent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu isBroken()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu leaves(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu listsTranslations(string $translationField)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu makeGap(int $cut, int $height)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu moveNode($key, $position)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu newModelQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu newQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu notTranslatedIn(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu orWhereAncestorOf(bool $id, bool $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu orWhereDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu orWhereNodeBetween($values)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu orWhereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu orWhereTranslation(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu orWhereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu orderByTranslation(string $translationField, string $sortMethod = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu pageWithFullContent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu query()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu rebuildSubtree($root, array $data, $delete = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu rebuildTree(array $data, $delete = false, $root = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu reversed()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu root(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu translated()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu translatedIn(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereAncestorOf($id, $andSelf = false, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereAncestorOrSelf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereCreatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereDescendantOf($id, $boolean = 'and', $not = false, $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereDescendantOrSelf(string $id, string $boolean = 'and', string $not = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereIsActive($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereIsAfter($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereIsBefore($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereIsLeaf()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereIsRoot()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereLft($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereNodeBetween($values, $boolean = 'and', $not = false, $query = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereParentId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereRgt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereTranslation(string $translationField, $value, ?string $locale = null, string $method = 'whereHas', string $operator = '=')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereType($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu whereUpdatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu withDepth(string $as = 'depth')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu withTranslation(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Menu withoutRoot()
 */
	class Menu extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\MenuItem
 *
 * @property int $id
 * @property int $menu_id
 * @property int $is_mega_menu
 * @property int $_lft
 * @property int $_rgt
 * @property int|null $parent_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Kalnoy\Nestedset\Collection<int, MenuItem> $children
 * @property-read int|null $children_count
 * @property-read \App\Models\Menu $menu
 * @property-read MenuItem|null $parent
 * @property-read \App\Models\MenuItemTranslation|null $translation
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\MenuItemTranslation> $translations
 * @property-read int|null $translations_count
 * @method static \Kalnoy\Nestedset\Collection<int, static> all($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem ancestorsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem ancestorsOf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem applyNestedSetScope(?string $table = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem countErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem d()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem defaultOrder(string $dir = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem descendantsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem descendantsOf($id, array $columns = [], $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem filterMenuItems(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem filterMenus(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem filterTranslations(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem filterTranslationsWithTextContent(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem filterUsers(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem fixSubtree($root)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem fixTree($root = null)
 * @method static \Kalnoy\Nestedset\Collection<int, static> get($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem getNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem getPlainNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem getTotalErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem hasChildren()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem hasParent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem isBroken()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem leaves(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem listsTranslations(string $translationField)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem makeGap(int $cut, int $height)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem moveNode($key, $position)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem newModelQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem newQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem notTranslatedIn(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem orWhereAncestorOf(bool $id, bool $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem orWhereDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem orWhereNodeBetween($values)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem orWhereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem orWhereTranslation(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem orWhereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem orderByTranslation(string $translationField, string $sortMethod = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem pageWithFullContent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem query()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem rebuildSubtree($root, array $data, $delete = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem rebuildTree(array $data, $delete = false, $root = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem reversed()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem root(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem translated()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem translatedIn(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereAncestorOf($id, $andSelf = false, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereAncestorOrSelf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereCreatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereDescendantOf($id, $boolean = 'and', $not = false, $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereDescendantOrSelf(string $id, string $boolean = 'and', string $not = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereIsAfter($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereIsBefore($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereIsLeaf()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereIsMegaMenu($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereIsRoot()
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereLft($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereMenuId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereNodeBetween($values, $boolean = 'and', $not = false, $query = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereParentId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereRgt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereTranslation(string $translationField, $value, ?string $locale = null, string $method = 'whereHas', string $operator = '=')
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem whereUpdatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem withDepth(string $as = 'depth')
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem withTranslation(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|MenuItem withoutRoot()
 */
	class MenuItem extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\MenuItemTranslation
 *
 * @property int $id
 * @property int $menu_item_id
 * @property string|null $locale
 * @property string $title
 * @property string $link
 * @property-read \App\Models\MenuItem $menuItem
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation query()
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation whereLink($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation whereMenuItemId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MenuItemTranslation whereTitle($value)
 */
	class MenuItemTranslation extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\MenuTranslation
 *
 * @property int $id
 * @property int $menu_id
 * @property string|null $locale
 * @property string $title
 * @property-read \App\Models\Menu $menu
 * @method static \Illuminate\Database\Eloquent\Builder|MenuTranslation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|MenuTranslation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|MenuTranslation query()
 * @method static \Illuminate\Database\Eloquent\Builder|MenuTranslation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MenuTranslation whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MenuTranslation whereMenuId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|MenuTranslation whereTitle($value)
 */
	class MenuTranslation extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Page
 *
 * @property int $id
 * @property int|null $page_type_id
 * @property string|null $cover_image
 * @property int $is_active
 * @property int $is_favorite
 * @property int $_lft
 * @property int $_rgt
 * @property int|null $parent_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Kalnoy\Nestedset\Collection<int, Page> $children
 * @property-read int|null $children_count
 * @property-read array $slug_parents
 * @property-read array $slug_tree
 * @property-read \App\Models\PageType|null $pageType
 * @property-read Page|null $parent
 * @property-read \Kalnoy\Nestedset\Collection<int, \App\Models\Sections\Section> $sections
 * @property-read int|null $sections_count
 * @property-read \App\Models\PageTranslation|null $translation
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PageTranslation> $translations
 * @property-read int|null $translations_count
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page active()
 * @method static \Kalnoy\Nestedset\Collection<int, static> all($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page ancestorsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page ancestorsOf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page applyNestedSetScope(?string $table = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page countErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page d()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page defaultOrder(string $dir = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page descendantsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page descendantsOf($id, array $columns = [], $andSelf = false)
 * @method static \Database\Factories\PageFactory factory($count = null, $state = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page filterMenuItems(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page filterMenus(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page filterTranslations(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page filterTranslationsWithTextContent(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page filterUsers(string $search)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page findBySlug($slugs)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page fixSubtree($root)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page fixTree($root = null)
 * @method static \Kalnoy\Nestedset\Collection<int, static> get($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page getNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page getPlainNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page getTotalErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page hasChildren()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page hasParent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page isBroken()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page leaves(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page listsTranslations(string $translationField)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page makeGap(int $cut, int $height)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page moveNode($key, $position)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page newModelQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page newQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page notTranslatedIn(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page orWhereAncestorOf(bool $id, bool $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page orWhereDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page orWhereNodeBetween($values)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page orWhereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page orWhereTranslation(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page orWhereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page orderByTranslation(string $translationField, string $sortMethod = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page pageWithFullContent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page query()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page rebuildSubtree($root, array $data, $delete = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page rebuildTree(array $data, $delete = false, $root = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page reversed()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page root(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page translated()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page translatedIn(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereAncestorOf($id, $andSelf = false, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereAncestorOrSelf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereCoverImage($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereCreatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereDescendantOf($id, $boolean = 'and', $not = false, $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereDescendantOrSelf(string $id, string $boolean = 'and', string $not = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereIsActive($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereIsAfter($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereIsBefore($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereIsFavorite($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereIsLeaf()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereIsRoot()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereLft($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereNodeBetween($values, $boolean = 'and', $not = false, $query = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page wherePageTypeId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereParentId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereRgt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereSlug($slug)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereTranslation(string $translationField, $value, ?string $locale = null, string $method = 'whereHas', string $operator = '=')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page whereUpdatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page withDepth(string $as = 'depth')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page withTranslation(?string $locale = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Page withoutRoot()
 */
	class Page extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\PageTranslation
 *
 * @property int $id
 * @property int $page_id
 * @property string|null $locale
 * @property string $slug
 * @property string $title
 * @property string|null $description
 * @property string|null $meta_title
 * @property string|null $meta_description
 * @property-read \App\Models\Page $page
 * @method static \Database\Factories\PageTranslationFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation query()
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation whereMetaDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation whereMetaTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation wherePageId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation whereSlug($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageTranslation whereTitle($value)
 */
	class PageTranslation extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\PageType
 *
 * @property int $id
 * @property string $name
 * @property string $slug
 * @property-read \Kalnoy\Nestedset\Collection<int, \App\Models\Page> $pages
 * @property-read int|null $pages_count
 * @method static \Illuminate\Database\Eloquent\Builder|PageType newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PageType newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PageType query()
 * @method static \Illuminate\Database\Eloquent\Builder|PageType whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageType whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PageType whereSlug($value)
 */
	class PageType extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\Role
 *
 * @property int $id
 * @property string $name
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $users
 * @property-read int|null $users_count
 * @method static \Database\Factories\RoleFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder|Role newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Role newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Role query()
 * @method static \Illuminate\Database\Eloquent\Builder|Role whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Role whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Role whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Role whereUpdatedAt($value)
 */
	class Role extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectElField
 *
 * @property int $id
 * @property int $section_element_id
 * @property int $sect_el_type_field_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Sections\SectElFieldTranslation|null $translation
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Sections\SectElFieldTranslation> $translations
 * @property-read int|null $translations_count
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField listsTranslations(string $translationField)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField notTranslatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField orWhereTranslation(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField orWhereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField orderByTranslation(string $translationField, string $sortMethod = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField translated()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField translatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField whereSectElTypeFieldId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField whereSectionElementId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField whereTranslation(string $translationField, $value, ?string $locale = null, string $method = 'whereHas', string $operator = '=')
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField whereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElField withTranslation(?string $locale = null)
 */
	class SectElField extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectElFieldTranslation
 *
 * @property int $id
 * @property int $sect_el_field_id
 * @property string $locale
 * @property int|null $int_value
 * @property string|null $string_value
 * @property string|null $text_value
 * @property int $boolean_value
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereBooleanValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereIntValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereSectElFieldId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereStringValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereTextValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElFieldTranslation whereUpdatedAt($value)
 */
	class SectElFieldTranslation extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectElType
 *
 * @property int $id
 * @property int $section_type_id
 * @property string $type
 * @property string|null $cover_image
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Sections\SectElTypeField> $fields
 * @property-read int|null $fields_count
 * @property-read \App\Models\Sections\SectionType $sectionType
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType whereCoverImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType whereSectionTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElType whereUpdatedAt($value)
 */
	class SectElType extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectElTypeField
 *
 * @property int $id
 * @property int $sect_el_type_id
 * @property string $name
 * @property string $data_type
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Sections\SectElType $sectElType
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField whereDataType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField whereSectElTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectElTypeField whereUpdatedAt($value)
 */
	class SectElTypeField extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\Section
 *
 * @property int $id
 * @property int $section_type_id
 * @property int $is_active
 * @property int $is_in_wrapper
 * @property int|null $page_type_id
 * @property int|null $number_items
 * @property string|null $cover_image
 * @property int $sectionable_id
 * @property string $sectionable_type
 * @property int $_lft
 * @property int $_rgt
 * @property int|null $parent_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property mixed $author
 * @property mixed $background_image
 * @property mixed $button_center_link
 * @property mixed $button_center_text
 * @property mixed $button_left_link
 * @property mixed $button_left_text
 * @property mixed $button_link
 * @property mixed $button_right_link
 * @property mixed $button_right_text
 * @property mixed $button_text
 * @property-read \Kalnoy\Nestedset\Collection<int, Section> $children
 * @property-read int|null $children_count
 * @property mixed $color
 * @property mixed $description
 * @property mixed $header_block_subtitle
 * @property mixed $header_block_title
 * @property mixed $image
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Image> $images
 * @property-read int|null $images_count
 * @property mixed $industry
 * @property mixed $left_column_text_content
 * @property mixed $link
 * @property mixed $location
 * @property mixed $organization
 * @property-read Section|null $parent
 * @property mixed $position
 * @property mixed $products
 * @property mixed $right_column_text_content
 * @property mixed $search_title
 * @property-read \Kalnoy\Nestedset\Collection<int, \App\Models\Sections\SectionElement> $sectionElements
 * @property-read int|null $section_elements_count
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Sections\SectionField> $sectionFields
 * @property-read int|null $section_fields_count
 * @property-read \App\Models\Sections\SectionType $sectionType
 * @property-read \Illuminate\Database\Eloquent\Model|\Eloquent $sectionable
 * @property mixed $solution
 * @property mixed $subtitle
 * @property mixed $text_content
 * @property mixed $title
 * @property mixed $title_image
 * @property mixed $video
 * @property mixed $website
 * @method static \Kalnoy\Nestedset\Collection<int, static> all($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section ancestorsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section ancestorsOf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section applyNestedSetScope(?string $table = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section countErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section d()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section defaultOrder(string $dir = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section descendantsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section descendantsOf($id, array $columns = [], $andSelf = false)
 * @method static \Database\Factories\Sections\SectionFactory factory($count = null, $state = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section filterByParentIdAndType(int $sectionableId, string $class)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section fixSubtree($root)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section fixTree($root = null)
 * @method static \Kalnoy\Nestedset\Collection<int, static> get($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section getNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section getPlainNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section getTotalErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section hasChildren()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section hasParent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section isBroken()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section leaves(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section makeGap(int $cut, int $height)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section moveNode($key, $position)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section newModelQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section newQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section orWhereAncestorOf(bool $id, bool $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section orWhereDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section orWhereNodeBetween($values)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section orWhereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section query()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section rebuildSubtree($root, array $data, $delete = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section rebuildTree(array $data, $delete = false, $root = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section reversed()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section root(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereAncestorOf($id, $andSelf = false, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereAncestorOrSelf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereCoverImage($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereCreatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereDescendantOf($id, $boolean = 'and', $not = false, $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereDescendantOrSelf(string $id, string $boolean = 'and', string $not = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereIsActive($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereIsAfter($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereIsBefore($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereIsInWrapper($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereIsLeaf()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereIsRoot()
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereLft($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereNodeBetween($values, $boolean = 'and', $not = false, $query = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereNumberItems($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section wherePageTypeId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereParentId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereRgt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereSectionTypeId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereSectionableId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereSectionableType($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section whereUpdatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section withDepth(string $as = 'depth')
 * @method static \Kalnoy\Nestedset\QueryBuilder|Section withoutRoot()
 */
	class Section extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectionElement
 *
 * @property int $id
 * @property int $sect_el_type_id
 * @property int $section_id
 * @property string $admin_title
 * @property string|null $cover_image
 * @property bool $is_active
 * @property int $_lft
 * @property int $_rgt
 * @property int|null $parent_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property mixed $article
 * @property mixed $author
 * @property mixed $background_image
 * @property mixed $big_image
 * @property mixed $button_link
 * @property mixed $button_right_link
 * @property mixed $button_right_text
 * @property mixed $button_text
 * @property-read \Kalnoy\Nestedset\Collection<int, SectionElement> $children
 * @property-read int|null $children_count
 * @property mixed $description
 * @property mixed $image
 * @property mixed $link
 * @property mixed $link_text
 * @property mixed $number
 * @property-read SectionElement|null $parent
 * @property mixed $position
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Sections\SectElField> $sectElFields
 * @property-read int|null $sect_el_fields_count
 * @property-read \App\Models\Sections\SectElType $sectElType
 * @property-read \App\Models\Sections\Section $section
 * @property mixed $small_image
 * @property mixed $subtitle
 * @property mixed $text_content
 * @property mixed $title
 * @method static \Kalnoy\Nestedset\Collection<int, static> all($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement ancestorsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement ancestorsOf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement applyNestedSetScope(?string $table = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement countErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement d()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement defaultOrder(string $dir = 'asc')
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement descendantsAndSelf($id, array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement descendantsOf($id, array $columns = [], $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement fixSubtree($root)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement fixTree($root = null)
 * @method static \Kalnoy\Nestedset\Collection<int, static> get($columns = ['*'])
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement getNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement getPlainNodeData($id, $required = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement getTotalErrors()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement hasChildren()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement hasParent()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement isBroken()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement leaves(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement makeGap(int $cut, int $height)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement moveNode($key, $position)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement newModelQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement newQuery()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement orWhereAncestorOf(bool $id, bool $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement orWhereDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement orWhereNodeBetween($values)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement orWhereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement query()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement rebuildSubtree($root, array $data, $delete = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement rebuildTree(array $data, $delete = false, $root = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement reversed()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement root(array $columns = [])
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereAdminTitle($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereAncestorOf($id, $andSelf = false, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereAncestorOrSelf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereCoverImage($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereCreatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereDescendantOf($id, $boolean = 'and', $not = false, $andSelf = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereDescendantOrSelf(string $id, string $boolean = 'and', string $not = false)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereIsActive($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereIsAfter($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereIsBefore($id, $boolean = 'and')
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereIsLeaf()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereIsRoot()
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereLft($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereNodeBetween($values, $boolean = 'and', $not = false, $query = null)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereNotDescendantOf($id)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereParentId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereRgt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereSectElTypeId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereSectionId($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement whereUpdatedAt($value)
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement withDepth(string $as = 'depth')
 * @method static \Kalnoy\Nestedset\QueryBuilder|SectionElement withoutRoot()
 */
	class SectionElement extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectionField
 *
 * @property int $id
 * @property int $section_id
 * @property int $section_type_field_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read mixed $title
 * @property-read \App\Models\Sections\SectionFieldTranslation|null $translation
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Sections\SectionFieldTranslation> $translations
 * @property-read int|null $translations_count
 * @method static \Database\Factories\Sections\SectionFieldFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField listsTranslations(string $translationField)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField notTranslatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField orWhereTranslation(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField orWhereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField orderByTranslation(string $translationField, string $sortMethod = 'asc')
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField translated()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField translatedIn(?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField whereSectionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField whereSectionTypeFieldId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField whereTranslation(string $translationField, $value, ?string $locale = null, string $method = 'whereHas', string $operator = '=')
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField whereTranslationLike(string $translationField, $value, ?string $locale = null)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionField withTranslation(?string $locale = null)
 */
	class SectionField extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectionFieldTranslation
 *
 * @property int $id
 * @property int $section_field_id
 * @property string $locale
 * @property int|null $int_value
 * @property string|null $string_value
 * @property string|null $text_value
 * @property int $boolean_value
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Database\Factories\Sections\SectionFieldTranslationFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereBooleanValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereIntValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereLocale($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereSectionFieldId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereStringValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereTextValue($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionFieldTranslation whereUpdatedAt($value)
 */
	class SectionFieldTranslation extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectionType
 *
 * @property int $id
 * @property string $type
 * @property string $cover_image
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Sections\SectElType|null $sectElType
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Sections\SectionTypeField> $sectionTypeFields
 * @property-read int|null $section_type_fields_count
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType whereCoverImage($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionType whereUpdatedAt($value)
 */
	class SectionType extends \Eloquent {}
}

namespace App\Models\Sections{
/**
 * App\Models\Sections\SectionTypeField
 *
 * @property int $id
 * @property int $section_type_id
 * @property string $name
 * @property string $data_type
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Models\Sections\SectionType $sectionType
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField query()
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField whereDataType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField whereSectionTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|SectionTypeField whereUpdatedAt($value)
 */
	class SectionTypeField extends \Eloquent {}
}

namespace App\Models{
/**
 * App\Models\User
 *
 * @property int $id
 * @property int $role_id
 * @property string $name
 * @property string $email
 * @property \Illuminate\Support\Carbon|null $email_verified_at
 * @property mixed $password
 * @property string|null $two_factor_secret
 * @property string|null $two_factor_recovery_codes
 * @property string|null $remember_token
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read mixed $verified
 * @property-read \Illuminate\Notifications\DatabaseNotificationCollection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
 * @property-read int|null $notifications_count
 * @property-read \App\Models\Role $role
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \Laravel\Sanctum\PersonalAccessToken> $tokens
 * @property-read int|null $tokens_count
 * @method static \Database\Factories\UserFactory factory($count = null, $state = [])
 * @method static \Illuminate\Database\Eloquent\Builder|User filterMenuItems(string $search)
 * @method static \Illuminate\Database\Eloquent\Builder|User filterMenus(string $search)
 * @method static \Illuminate\Database\Eloquent\Builder|User filterTranslations(string $search)
 * @method static \Illuminate\Database\Eloquent\Builder|User filterTranslationsWithTextContent(string $search)
 * @method static \Illuminate\Database\Eloquent\Builder|User filterUsers(string $search)
 * @method static \Illuminate\Database\Eloquent\Builder|User newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|User newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|User pageWithFullContent()
 * @method static \Illuminate\Database\Eloquent\Builder|User query()
 * @method static \Illuminate\Database\Eloquent\Builder|User whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereEmailVerifiedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereRememberToken($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereRoleId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereTwoFactorRecoveryCodes($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereTwoFactorSecret($value)
 * @method static \Illuminate\Database\Eloquent\Builder|User whereUpdatedAt($value)
 */
	class User extends \Eloquent implements \Illuminate\Contracts\Auth\MustVerifyEmail {}
}

